function createDigitalRain() {
    const container = document.querySelector('.digital-rain');
    const characters = '01';
    const columns = Math.floor(window.innerWidth / 12);

    container.innerHTML = '';

    for (let i = 0; i < columns; i++) {
        const span = document.createElement('span');
        span.innerText = characters.charAt(Math.floor(Math.random() * characters.length));
        span.style.left = i * 12 + 'px';
        span.style.animationDuration = Math.random() * 1 + 1 + 's';
        span.style.animationDelay = Math.random() * 2 + 's';
        span.style.opacity = Math.random() * 0.5 + 0.4;
        container.appendChild(span);
    }
}

createDigitalRain();

let resizeTimeout;
window.addEventListener('resize', () => {
    clearTimeout(resizeTimeout);
    resizeTimeout = setTimeout(createDigitalRain, 100);
});

setInterval(createDigitalRain, 3000);

function showSearchResult() {
    const searchResult = document.getElementById('searchResult');
    searchResult.classList.add('active');
}

function hideSearchResult() {
    const searchResult = document.getElementById('searchResult');
    searchResult.classList.remove('active');
}

document.getElementById('searchResult').addEventListener('click', function(e) {
    if (e.target === this) {
        hideSearchResult();
    }
});
